<!-- Fix for scroll issue in new booking -->
<style type="text/css">
  .modal { overflow-y: auto; }
  .unsaved-alert {
    display:none;
    margin: 0;
    border-left: 4px solid #f39c12;
    background: #fff7e6;
    color: #8a6d3b;
    padding: 8px 12px;
    font-size: 12px;
  }
</style>

<div class="modal-dialog" role="document">
  <div class="modal-content">
    {!! Form::open(['url' => $notification_template['template_for'] == 'send_ledger' ? action([\App\Http\Controllers\ContactController::class, 'sendLedger']) : action([\App\Http\Controllers\NotificationController::class, 'send']), 'method' => 'post', 'id' => 'send_notification_form' ]) !!}

    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <h4 class="modal-title">@lang('lang_v1.send_notification') - {{$template_name}}</h4>
      <div id="unsaved_alert" class="unsaved-alert">
        <strong>@lang('messages.warning'):</strong>
        @lang('lang_v1.you_have_unsaved_changes') {{-- fallback if not translated --}}
        <span class="help-text">Changes detected. Don't forget to send/save.</span>
      </div>
    </div>

    <div class="modal-body">
        <div>
            <strong>@lang('lang_v1.available_tags'):</strong>
            @include('notification_template.partials.tags', ['tags' => $tags])
        </div>
        <div class="box-group" id="accordion">
            {{-- email --}}
            <div class="panel box box-solid">
              <div class="box-header with-border">
                <h4 class="box-title">
                  <a data-toggle="collapse" data-parent="#accordion" href="#email_collapse" aria-expanded="true">
                   @lang('lang_v1.send_email')
                  </a>
                </h4>
              </div>
              <div id="email_collapse" class="panel-collapse collapse in" aria-expanded="true">
                <div class="box-body">
                    @if($notification_template['template_for'] == 'send_ledger')
                        <div class="form-group">
                            {!! Form::label('ledger_format', __('lang_v1.ledger_format').':') !!}
                            {!! Form::select('ledger_format', ['format_1' => __('lang_v1.format_1'), 'format_2' => __('lang_v1.format_2')], $ledger_format, ['class' => 'form-control']); !!}
                        </div>
                    @endif
                    <div class="form-group @if($notification_template['template_for'] == 'send_ledger') hide @endif">
                        <label>
                          {!! Form::checkbox('notification_type[]', 'email', true, ['class' => 'input-icheck notification_type']); !!} @lang('lang_v1.send_email')
                        </label>
                    </div>
                  <div id="email_div">
                    <div class="form-group">
                      {!! Form::label('to_email', __('lang_v1.to').':') !!} @show_tooltip(__('lang_v1.notification_email_tooltip'))
                      {!! Form::text('to_email', $contact->email, ['class' => 'form-control' , 'placeholder' => __('lang_v1.to')]); !!}
                    </div>
                    <div class="form-group">
                      {!! Form::label('subject', __('lang_v1.email_subject').':') !!}
                      {!! Form::text('subject', $notification_template['subject'], ['class' => 'form-control' , 'placeholder' => __('lang_v1.email_subject')]); !!}
                    </div>
                    <div class="form-group">
                      {!! Form::label('cc', 'CC:') !!}
                      {!! Form::email('cc', $notification_template['cc'], ['class' => 'form-control' , 'placeholder' => 'CC']); !!}
                    </div>
                    <div class="form-group">
                      {!! Form::label('bcc', 'BCC:') !!}
                      {!! Form::email('bcc', $notification_template['bcc'], ['class' => 'form-control' , 'placeholder' => 'BCC']); !!}
                    </div>
                    <div class="form-group">
                      {!! Form::label('email_body', __('lang_v1.email_body').':') !!}
                      {!! Form::textarea('email_body', $notification_template['email_body'], ['class' => 'form-control', 'placeholder' => __('lang_v1.email_body'), 'rows' => 6, 'id' => 'email_body']); !!}
                    </div>
                    @if(config('constants.enable_download_pdf') && $notification_template['template_for'] == 'new_sale')
                        <label>
                          {!! Form::checkbox('attach_pdf', true, false, ['class' => 'input-icheck notification_type']); !!}
                          @lang('lang_v1.attach_pdf_in_email')
                        </label>
                    @endif
                    @if($notification_template['template_for'] == 'send_ledger')
                      <p class="help-block">*@lang('lang_v1.ledger_attacment_help')</p>
                    @endif
                  </div>
                </div>
              </div>
            </div>

            {{-- sms / whatsapp --}}
            @if($notification_template['template_for'] != 'send_ledger')
                <div class="panel box box-solid">
                  <div class="box-header with-border">
                    <h5 class="box-title">
                      <a data-toggle="collapse" data-parent="#accordion" href="#sms_collapse" class="collapsed" aria-expanded="false">
                        @lang('lang_v1.send_sms_whatsapp_notification')
                      </a>
                    </h5>
                  </div>
                  <div id="sms_collapse" class="panel-collapse collapse" aria-expanded="false">
                    <div class="box-body">
                        <div class="form-group @if($notification_template['template_for'] == 'send_ledger') hide @endif">
                            <label>
                              {!! Form::checkbox('notification_type[]', 'sms', false, ['class' => 'input-icheck notification_type']); !!} @lang('lang_v1.send_sms')
                            </label>
                            <label>
                              {!! Form::checkbox('notification_type[]', 'whatsapp', false, ['class' => 'input-icheck notification_type']); !!} @lang('lang_v1.send_whatsapp')
                            </label>
                          </div>
                          <div class="form-group">
                            {!! Form::label('mobile_number', __('lang_v1.mobile_number').':') !!}
                            {!! Form::text('mobile_number', $contact->mobile, ['class' => 'form-control', 'placeholder' => __('lang_v1.mobile_number')]); !!}
                          </div>
                          <div id="sms_div" class="hide">
                            <div class="form-group">
                              {!! Form::label('sms_body', __('lang_v1.sms_body').':') !!}
                              {!! Form::textarea('sms_body', $notification_template['sms_body'], ['class' => 'form-control', 'placeholder' => __('lang_v1.sms_body'), 'rows' => 6]); !!}
                            </div>
                          </div>
                          <div id="whatsapp_div" class="hide">
                              {!! Form::label('whatsapp_text', __('lang_v1.whatsapp_text').':') !!}
                              {!! Form::textarea('whatsapp_text', $notification_template['whatsapp_text'], ['class' => 'form-control', 'placeholder' => __('lang_v1.whatsapp_text'), 'rows' => 6]); !!}
                          </div>
                    </div>
                  </div>
                </div>
            @endif
        </div>

        @if(!empty($transaction))
            {!! Form::hidden('transaction_id', $transaction->id); !!}
        @endif

        @if($notification_template['template_for'] == 'send_ledger')
            {!! Form::hidden('contact_id', $contact->id); !!}
            {!! Form::hidden('start_date', $start_date); !!}
            {!! Form::hidden('end_date', $end_date); !!}
            {!! Form::hidden('location_id', $location_id); !!}
        @endif
        {!! Form::hidden('template_for', $notification_template['template_for']); !!}
        <div class="modal-footer">
          <button type="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white" id="send_notification_btn">@lang('lang_v1.send')</button>
          <button type="button" class="tw-dw-btn tw-dw-btn-neutral tw-text-white" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->

<script type="text/javascript">
  // TinyMCE init (kept as-is)
  if (_.isNull(tinyMCE.activeEditor)) {
    tinymce.init({ selector: 'textarea#email_body' });
  }

  $(document).ready(function(){
    // initialize iCheck
    $('input[type="checkbox"].input-icheck, input[type="radio"].input-icheck').iCheck({
      checkboxClass: 'icheckbox_square-blue',
      radioClass: 'iradio_square-blue'
    });
  });

  // --- Change detection / user notifications (kept) ---
  (function(){
    var $form = $('#send_notification_form');
    var $alert = $('#unsaved_alert');
    var initial = null;
    var dirty = false;
    var toasted = false;

    function snapshot(){
      if (typeof tinyMCE !== 'undefined' && tinyMCE.activeEditor) { tinyMCE.triggerSave(); }
      return $form.serialize();
    }
    function setDirty(flag){
      dirty = !!flag;
      if (dirty) {
        $alert.stop(true,true).fadeIn(120);
        if (!toasted && typeof toastr !== 'undefined') {
          toastr.info("@lang('lang_v1.changes_detected')", null, {timeOut: 2000});
          toasted = true;
        }
      } else {
        $alert.stop(true,true).fadeOut(120);
      }
    }
    function checkDirty(){ setDirty(snapshot() !== initial); }

    setTimeout(function(){ initial = snapshot(); }, 200);

    $form.on('change keyup paste', 'input, select, textarea', checkDirty);
    $(document).on('ifChanged', '.input-icheck', checkDirty);

    $(document).on('focusin', function(e){
      if ($(e.target).closest(".mce-window, .moxman-window").length) e.stopImmediatePropagation();
    });
    setTimeout(function(){
      try{
        if (tinyMCE && tinyMCE.editors && tinyMCE.editors.length){
          tinyMCE.editors.forEach(function(ed){
            ed.on('change input keyup undo redo', function(){ tinyMCE.triggerSave(); checkDirty(); });
          });
        }
      }catch(e){}
    }, 300);

    $('div.view_modal').on('hide.bs.modal', function(e){
      if (dirty) {
        if (!confirm("@lang('lang_v1.unsaved_changes_warning')\n@lang('lang_v1.discard_changes_question')")) {
          e.preventDefault();
        }
      }
    });

    window.addEventListener('beforeunload', function (e) {
      var modalVisible = $('div.view_modal:visible').length > 0;
      if (dirty && modalVisible) { e.preventDefault(); e.returnValue = ''; }
    });

    $(document).on('notification:submitted', function(){
      initial = snapshot();
      setDirty(false);
      toasted = false;
    });
  })();
  // --- End change detection ---

  // Existing toggle logic for showing email/sms/whatsapp bodies
  $(document).on('ifChanged', '.notification_type', function(){
    var notification_type = $(this).val();
    if (notification_type == 'email') {
      $(this).is(':checked') ? $('div#email_div').removeClass('hide') : $('div#email_div').addClass('hide');
    } else if(notification_type == 'sms'){
      $(this).is(':checked') ? $('div#sms_div').removeClass('hide') : $('div#sms_div').addClass('hide');
    } else if(notification_type == 'whatsapp'){
      $(this).is(':checked') ? $('div#whatsapp_div').removeClass('hide') : $('div#whatsapp_div').addClass('hide');
    }
  });

  /**
   * === Frontend-only: add a line to the bell dropdown ===
   * No backend changes. It finds your bell trigger (#show_unread_notifications),
   * targets the first UL.dropdown-menu beside it, removes the "No notifications found"
   * placeholder if present, then prepends a new item.
   */
  function addInAppDropdownNotification(opts){
    var o = $.extend({
      title: "@lang('lang_v1.notification')",
      message: "@lang('messages.success')",
      url: window.location.href,
      icon: 'ti ti-bell' // adjust to your icon set if needed
    }, opts || {});

    // Find the dropdown UL that belongs to the bell
    var $trigger = $('#show_unread_notifications');
    var $menu = $trigger.closest('li, .dropdown, .tw-dw-dropdown').find('ul.dropdown-menu').first();
    if (!$menu.length) { $menu = $('ul.dropdown-menu.notifications, ul.dropdown-menu').first(); }
    if (!$menu.length) { return; }

    // Remove any "empty" placeholders commonly used in templates
    $menu.find('.empty, .no-notifications, [data-empty="1"], li:contains("No notifications found")').remove();

    var now = new Date();
    var $li = $('<li/>', { class: 'notification-item tw-flex tw-items-start tw-gap-2 tw-p-2' });
    var $icon = $('<i/>', { class: o.icon + ' tw-mt-1' });
    var $body = $('<div/>', { class: 'tw-text-sm tw-leading-snug' })
                  .append($('<div/>', { class: 'tw-font-medium', text: o.title }))
                  .append($('<div/>', { class: 'tw-text-gray-600', text: o.message }))
                  .append($('<div/>', { class: 'tw-text-[11px] tw-text-gray-400', text: now.toLocaleString() }));

    if (o.url) {
      var $a = $('<a/>', { href: o.url, class: 'tw-flex tw-items-start tw-gap-2 tw-no-underline tw-text-inherit' })
                 .append($icon, $body);
      $li.append($a);
    } else {
      $li.append($icon, $body);
    }

    $menu.prepend($li);

    // Optional: bump a count badge if present
    var $badge = $('#notification_count, .notification-count, [data-notification-count]').first();
    if ($badge.length) {
      var n = parseInt(($badge.text() || '0').replace(/\D/g,''), 10) || 0;
      $badge.text(n + 1).show();
    }
  }

  // Submit (AJAX) – unchanged + inject bell notification on success
  $('#send_notification_form').submit(function(e){
    e.preventDefault();
    tinyMCE.triggerSave();
    var btn = $('#send_notification_btn');
    btn.text("@lang('lang_v1.sending')...").attr('disabled', 'disabled');

    $.ajax({
      method: "POST",
      url: $(this).attr("action"),
      dataType: "json",
      data: $(this).serialize(),
      beforeSend: function(xhr) { __disable_submit_button(btn); },
      success: function(result){
        if(result.success == true){
          if (result.whatsapp_link) { window.open(result.whatsapp_link); }
          $('div.view_modal').modal('hide');
          toastr.success(result.msg);

          // >>> add to bell dropdown immediately (no backend changes)
          addInAppDropdownNotification({
            title: "@lang('lang_v1.send_notification')",
            message: result.msg || "Action completed successfully.",
            url: window.location.href
          });

          // reset "dirty" tracker
          $(document).trigger('notification:submitted');
        } else {
          toastr.error(result.msg);
        }
        $('#send_notification_btn').text("@lang('lang_v1.send')").removeAttr('disabled');
      },
      error: function(){
        $('#send_notification_btn').text("@lang('lang_v1.send')").removeAttr('disabled');
        toastr.error("@lang('messages.something_went_wrong')");
      }
    });
  });
</script>

